/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#ifndef _DRIVERLAYER_H_
#define _DRIVERLAYER_H_

#include "Conf.h"

class iDriverLayer {
    public:
        virtual ~iDriverLayer() { };
        virtual int* getU4ABoards(int&) =0;
        virtual int qtyDsc(int) =0;
        virtual dscEndpoint* getEndpointDsc(int, int) =0;
        virtual int openIn(int, int, int) =0;
        virtual int openOut(int, int, int) =0;
        virtual bool close(int) =0;
        virtual bool sendInt(int, char *, int, int) =0;
        virtual bool sendCtrl(int, char*, int, int) =0;
        virtual bool sendIso(int, char*, int, int) = 0;
        virtual bool sendBulk(int, char*, int, int) =0;
        virtual char* receiveInt(int, int&, bool&, int) =0;
        virtual char* receiveCtrl(int, int&, bool&, int) =0;
        virtual char* receiveIso(int, int&, bool&, int) =0;
        virtual char* receiveBulk(int, int&, bool&, int) =0;
};

#endif
